-----------------------------------------------------------------
--    
-----------------------------------------------------------------
function countUnits(force)
calls.enter("countUnits",force)
	local alive = 0
	local all = 0
	
	log("__countUnits", force)
	
	local count = function(index, unit)
		if(isUnitValid(unit)) then
			log("__countUnits", unit)
			all = all + 1
			log("__countUnits", all)
			if (healthOK(unit)) then
				alive = alive + 1
				log("__countUnits", alive)
			end
		end
	end
	
	table.foreach(CUR_MISSION.Units[force], count)
calls.leave("countUnits",force)	
	return all, alive
end

function checkCondition(condition)
calls.enter("checkCondition",condition)
	if (condition == "client_task_1") then
		if (CURRENT_ALLY == CORP) then
			if ( 
				((AIRPORT_CAPTURED == true) or (Sectors["airport"].owner == CURRENT_ALLY)) and
				((TRAINSTAION_CAPTURED == true) or (Sectors["trainstation"].owner == CURRENT_ALLY)) and
				((BASE_CAPTURED == true) or (Sectors["base"].owner == CURRENT_ALLY)) and
				((DAM_CAPTURED == true) or (Sectors["dam"].owner == CURRENT_ALLY)) and
				((PORT_CAPTURED == true)  or (Sectors["port"].owner == CURRENT_ALLY)) ) then
				
				if (Sectors["crossroads"].owner == CURRENT_ALLY) then
					sendMail("janus_ambush_01", nil, nil, false)
					--Emails["janus_ambush_01"].send(false)
					changeBadReputation(-2)
				end
			end
		end
	elseif (condition == "capture_country") then

		if (CURRENT_ALLY == ARMY) then
			local ok = true
			
			local checkSectors = function(sector, data)
				if ((sector ~= "north_road") and 
					(sector ~= "safari") and 
					(sector ~= "drug_deal") and 
					(sector ~= "test_level") and 
					(sector ~= "un_camp") ) then

					if (data.owner ~= ARMY) then
						ok = false
						return(1)
					end
				end
			end
			
			table.foreach(Sectors, checkSectors)
			
			if (ok == true) then
				onGameOver("on_capture")
			end
		else
			local ok = true
			
			local checkSectors = function(sector, data)
				if ((sector ~= "north_road") and 
					(sector ~= "safari") and 
					(sector ~= "drug_deal") and 
					(sector ~= "test_level") and 
					(sector ~= "un_camp") ) then 

					local ownerOk = (
						(data.owner == CURRENT_ALLY) or
						((data.owner == PIRATS) and (CURRENT_ALLY==MARAUDERS)) or
						((sector=="mountain_village") and (not Sectors["mountain_village"].enabled)) or
						((sector=="outpost") and (not Sectors["outpost"].enabled)) or
						((sector=="pirate_island") and (not Sectors["pirate_island"].enabled)))

log("victory",sector,data.owner,ownerOk)

					if(not ownerOk) then
						ok = false
						return(1)
					end
				end
			end
			
			table.foreach(Sectors, checkSectors)
			
			if (ok == true) then
				onGameOver("on_capture")
			end
		end
	end
calls.leave("checkCondition",condition)
end

function discoverSectors(parent)
calls.enter("discoverSectors",parent)
	local children = Joints[parent]
	
	local discover = function(sector, data)
		if (Sectors[sector].exclusive == false) then
			if (Sectors[sector].enabled == false) then
				Sectors[sector].enabled = true
			end
		end
	end
	
	table.foreach(children, discover)
calls.leave("discoverSectors",parent)
end

function processOnKill(sector)
calls.enter("processOnKill",sector)
	local owner = Sectors[sector].owner
	
	if ( CURRENT_ALLY == owner ) then
calls.leave("processOnKill",sector)
		return
	end
	
	local all, alive = countUnits(owner) --is_force_alive, is_somebody_killed = check_local_force(CUR_MISSION.Units[owner])
	
	if ( getGVAR("GLOBAL_WAR_BEGAN") == _NO ) then
		if ( all > alive ) then
			setGVAR("GLOBAL_WAR_BEGAN", _YES)
		end
	end
	
	if ( Sectors[sector].isClean == false ) then
		if ( alive == 0 ) then
			onVictory()
		end
	end
calls.leave("processOnKill",sector)
end

function processOnEnd(sector)
calls.enter("processOnEnd",sector)
	local owner = Sectors[sector].owner
	
	if ( CURRENT_ALLY == owner ) then
calls.leave("processOnEnd",sector)
		return
	end
	
--	if ( Sectors[sector].isClean == true ) then
--		Sectors[sector].owner = CURRENT_ALLY
--	end
calls.leave("processOnEnd",sector)
end

function onVictory()
calls.enter("onVictory")
	--
	sendSystemMessage("sector_clean")
	--
	SQUADS_ENTRANCES[CUR_MISSION.Name] = nil
	
	CUR_MISSION.Success = true
	
	Sectors[CUR_MISSION.Name].isClean = true
	
	if ( Sectors[CUR_MISSION.Name].isDone == false ) then
		Sectors[CUR_MISSION.Name].isDone = true
		if (CURRENT_ALLY == CORP) then
			if ( Sectors[CUR_MISSION.Name].reward ~= 0 ) then
				addMoney(Sectors[CUR_MISSION.Name].reward)
			end
		end
	end
	
	local pleaseStandUpForSlimShady = function(index, merc)
		if Mercs[merc].alive == true then
			if ( healthOK(merc) ) then
				addPose(merc, "stand")
				executeOrders(merc)
			end
		end
	end
	
	table.foreach(CUR_MISSION.Mercs, pleaseStandUpForSlimShady)
	
	if (FIRST_SECTOR_CAPTURED == false) then
		FIRST_SECTOR_CAPTURED = true
		sendMail("press_01", nil, nil, false)
		--Emails["press_01"].send(false)
		changeBadReputation(-1)
	end
	
	if (Sectors[CUR_MISSION.Name].owner == CORP) then
		if (Forces[CORP][PLAYER] == ENEMY) then
			if (CORP_SECTORS_CAPTURED == 0) then
				CORP_SECTORS_CAPTURED = 1
				sendMail("janus_rage_01", nil, nil, false)
				--Emails["janus_rage_01"].send(false)
			elseif (CORP_SECTORS_CAPTURED == 1) then
				CORP_SECTORS_CAPTURED = 2
				sendMail("janus_rage_02", nil, nil, false)
				--Emails["janus_rage_02"].send(false)
			end
		end
	end

	Sectors[CUR_MISSION.Name].owner = CURRENT_ALLY	
	changeBadReputation(-1)
	
	checkCondition("capture_country")
calls.leave("onVictory")
end

function onGameOver(reason)
calls.enter("onGameOver",reason)
	if ( "on_kill" == reason ) then
		if ( CORP == CURRENT_ALLY ) then
			--video1
			showMessageBox("game_over_client", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_01.bik"
			endCampaign()
		elseif ( BUTSI == CURRENT_ALLY ) then
			--video2
			showMessageBox("game_over_butsi", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_02a.bik"
			endCampaign()
		elseif ( MARAUDERS == CURRENT_ALLY ) then
			--video2
			showMessageBox("game_over_marauders", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_02b.bik"
			endCampaign()
		else
			--video3
			showMessageBox("game_over_player", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_02b.bik"
			endCampaign()
		end
	end

	if ( "on_capture" == reason ) then
		if ( ARMY == CURRENT_ALLY ) then
			--video3
			showMessageBox("game_over_dictator", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_03.bik"
			endCampaign()
		elseif( CORP == CURRENT_ALLY ) then
			--video1
			showMessageBox("game_over_client_nokill", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_01.bik"
			endCampaign()
		elseif ( BUTSI == CURRENT_ALLY ) then
			--video2
			showMessageBox("game_over_butsi_nokill", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_02a.bik"
			endCampaign()
		elseif ( MARAUDERS == CURRENT_ALLY ) then
			--video2
			showMessageBox("game_over_marauders_nokill", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_02b.bik"
			endCampaign()
		else
			--video3
			showMessageBox("game_over_player", OK, BIG)
			
			if ( CUR_MISSION.Finishing == false ) then
				finishMission(false)
			end
			
			VIDEO_TO_PLAY = "video/end_02b.bik"
			endCampaign()
		end
	end
calls.leave("onGameOver",reason)
end

function prepareMissionForces(sector)
calls.enter("prepareMissionForces",sector)
	local owner = Sectors[sector].owner
	local local_forces = { getMissionPlayers(sector) }
	local mi = getMilitiaInfo(sector)

	if ( (CURRENT_ALLY ~= owner) and (mi ~= nil) and (mi.num ~= nil) and (mi.num > 0) )then
		spawnDefenders(sector, owner, mi.num, false)
		Sectors[sector].isClean = false
	elseif ( CURRENT_ALLY == owner ) then
		spawnMilitia()
	end
	
	local updateRelations = function(index, force)
		local global_force = CUR_MISSION.Forces[force]
		
		if ( force ~= PLAYER ) then
			if ( global_force ~= PLAYER ) then
				changeLocalRelations(Forces[global_force][PLAYER], force)
			end
		end
	end
	
	table.foreach(local_forces, updateRelations)

calls.leave("prepareMissionForces",sector)
end

function checkIfMercIsOnList(merc)
calls.enter("checkIfMercIsOnList",merc)
	local res = false
	local check = function(index, name)
		if ( name ~= nil ) then
			if ( name == merc ) then
				res = true
			end
		end
	end
	
	table.foreach(CUR_MISSION.Mercs, check)
calls.leave("checkIfMercIsOnList",merc)	
	return res
end

function resetBD()
calls.enter("resetBD")
	BATTLE_DATA.Attacker = nil
	BATTLE_DATA.AttackingUnits = {}
	BATTLE_DATA.AttackerSize = 0
	BATTLE_DATA.Sector = nil
	BATTLE_DATA.Enabled = false
	BATTLE_DATA.Entrance = nil
calls.leave("resetBD")
end

function checkPlayerSquad(data)
calls.enter("checkPlayerSquad",data)
	local res = -1
	
	if (data == "squad1") then res = 1 end
	if (data == "squad2") then res = 2 end
	if (data == "squad3") then res = 3 end
	if (data == "squad4") then res = 4 end
	if (data == "squad5") then res = 5 end
	if (data == "squad6") then res = 6 end
calls.leave("checkPlayerSquad",data)	
	return res
end

function healthOK(id)
calls.enter("healthOK",id)
	if (IsAlive(id)) then
		if (getPersonParameter(id, "HEALTH") > 15) then
calls.leave("healthOK",id)
			return true
		end
	end
calls.leave("healthOK",id)
	return false
end

function getClosestMerc(id, list)
calls.enter("getClosestMerc",id)
	local m = deepcopy(CUR_MISSION.Mercs)
	local closest_merc = nil
	local last_dist = nil
	
	local check = function(index, name)
		if (name ~= nil) then
			if (Mercs[name].hired == true) then
				if (healthOK(name)) then
					local dist = service.person2person_distance(id, name)
	
					if (closest_merc == nil) then
						closest_merc = name
						last_dist = dist
					elseif (dist < last_dist) then
						closest_merc = name
						last_dist = dist
					end
				end
			end
		end
	end
	
	if (list == nil) then
		table.foreach(m, check)
	else
		table.foreach(list, check)
	end
calls.leave("getClosestMerc",id)	
	return closest_merc
end

function mergeTables(source, destination)
calls.enter("mergeTables")
	local res = destination
	local merge = function(index, data)
		table.insert(res, data)
	end
	
	table.foreach(source, merge)
calls.leave("mergeTables")
	return res
end

function checkIfAnySquadIsInSector(sector)
calls.enter("checkIfAnySquadIsInSector",sector)
	local spos = SQUADS_POSITIONS
	local res = false
	
	local check = function(index, pos)
		if (pos == sector) then
			res = true
		end
	end
	
	table.foreach(spos, check)
calls.leave("checkIfAnySquadIsInSector",res)	
	return res
end

function initMissionScript()
calls.enter("initMissionScript")
	log("_mission_script_init", "Initializing mission script data", CUR_MISSION.Name)
	
	local players = { getMissionPlayers(CUR_MISSION.Name) }
	
	local init = function(index, side)
		if (side ~= PLAYER) then
			CUR_MISSION.Units[side] = {}
			CUR_MISSION.Units[side] = service.getPlayerUnits(side)
			log("_mission_script_init", side, "units initialized")
		end
	end
	
	table.foreach(players, init)

	CUR_MISSION.Forces[ARMY] = ARMY
	CUR_MISSION.Forces[CORP] = CORP
	CUR_MISSION.Forces[PLAYER] = PLAYER
	CUR_MISSION.Forces[BUTSI] = BUTSI
	CUR_MISSION.Forces[CIVILIANS] = CIVILIANS
	CUR_MISSION.Forces[MARAUDERS] = MARAUDERS
	CUR_MISSION.Forces[PIRATS] = PIRATS
	CUR_MISSION.Forces[REBELS] = REBELS
	CUR_MISSION.Forces[UN] = UN
	CUR_MISSION.Forces.civilians = CIVILIANS
	CUR_MISSION.Forces.staff = CIVILIANS
	CUR_MISSION.Forces.un = UN
	CUR_MISSION.Forces.butsi = BUTSI
	CUR_MISSION.Forces.captive = BUTSI
	CUR_MISSION.Forces.corp = CORP
	CUR_MISSION.Forces.army = ARMY
	CUR_MISSION.Forces.boss = CIVILIANS
	CUR_MISSION.Forces.marauders = MARAUDERS
	CUR_MISSION.Forces.quest_npc = CIVILIANS
	CUR_MISSION.Forces.pirates = PIRATS
	CUR_MISSION.Forces.gang_1 = MARAUDERS
	CUR_MISSION.Forces.gang_2 = PIRATS
	CUR_MISSION.Forces.guide_family = CIVILIANS
	CUR_MISSION.Forces.rebels = REBELS
	CUR_MISSION.Forces.militia = BUTSI
	CUR_MISSION.Forces.mafia = MARAUDERS
	CUR_MISSION.Forces.guards = ARMY
	
	log("_mission_script_init", "Initializing succesfully finished")
calls.leave("initMissionScript")
end

function sectorsUnderControl(force)
calls.enter("sectorsUnderControl",force)
	local num = 0
	
	local count = function(sector, data)
		if ((data.owner == force) or (Forces[data.owner][force] == ALLY)) then
			num = num + 1
		end
	end
	
	table.foreach(Sectors, count)
calls.leave("sectorsUnderControl",num)	
	return num
end

function dangerArea(trigger_name,damage,duration)
calls.enter("dangerArea",trigger_name)
	log("dangerArea","START",damage,duration)
	local start_time=0
	local process=function(id,data)
		log("dangerArea","CHECK",id)
		local x,y,z,f=getPosition(id)
		if (trigger_utility.isPersonPresent(trigger_name,id)) then 
			local health = getPersonParameter(id, "HEALTH")
			local new_health = health - damage
			if (new_health < 0) then
				new_health = 0
			end
			
			setPersonParameter(id, "HEALTH", new_health)
			
			--blast(x, y, z, 0.3, damage)
			log("dangerArea","DAMAGE",id,x,y,z)
		else
			log("dangerArea","NOT IN TRIGGER",id,x,y,z)
		end
	end
	
	if (duration~=0) then 
	log("dangerArea","DURATION~=0")
		if (start_time<=duration) then
			log("dangerArea","start_time<=duration")
			if (isGameInRT()) then
				log("dangerArea","RT")
				start_time=start_time+1
				table.foreach(Humans,process)
			else
			end
		else
			log("dangerArea","DONE")
			Triggers[trigger_name].active=false
		end
	else
		log("dangerArea","DURATION=0")
		if (isGameInRT()) then
		log("dangerArea","RT")
			table.foreach(Humans, process)
		end	
	end
calls.leave("dangerArea",trigger_name)
end

function damageReactor(trigger_name, reactors, reaction_remark, next_trigger)
calls.enter("damageReactor",trigger_name)
	if (reactors == nil) then 
		showMessageBox("damageReactor_error_reactors", OK, SMALL)
		log("damageReactor", "empty reactors")
calls.leave("damageReactor",trigger_name)
		return
	end
	
	log("damageReactor", trigger_name, reactors)
	
	local collect = function(index, value)
		if (trigger_utility.isPersonHurted(value)) then
			
			if (isValid(reaction_remark)) then
				showComments(reactors[1], reaction_remark, table_values.corner, 1, 0, 5)
			end
			
			local offender = trigger_service.hurt_observer.hurts[value]
			
			if (isValid(offender)) then
				local offender_team = team(offender)
				
				changeLocalRelations(ENEMY, team(reactors[1]), offender_team)
			end
			
			if (isValid(next_trigger)) then
				Triggers[next_trigger].active = true
			end
			
			if (isValid(trigger_name)) then
				Triggers[trigger_name].active = false
			end

			return
		end
	end
	
	table.foreach(reactors, collect)
calls.leave("damageReactor",trigger_name)
end
--
function checkPointer(sector, trigger_name, controllers, warning_remark, combat_remark, dialog, time_out, time, weapons_check, check_distance, weapons_remark, weapons_aggressive, dialog_dist)
calls.enter("checkPointer",sector)	
	sector = CUR_MISSION.Name
	
	if (dialog_dist == nil) then
		dialog_dist = 5
	end

	if (sector == nil) then
		showMessageBox("checkpointer_error_sector", OK, SMALL)
		log("checkPointer", "empty sector")
calls.leave("checkPointer",sector)
		return
	end
	
	if (controllers == nil) then 
		showMessageBox("checkpointer_error_controllers", OK, SMALL)
		log("checkPointer", "empty controllers")
calls.leave("checkPointer",sector)
		return
	end
	
	log("checkPointer", sector, trigger_name, controllers, time_out, time, weapons_check, check_distance, weapons_aggressive, next_trigger)
	
	local leader = controllers[1]
	local visible = false
	local visible_mercs = {}
	local merc = getClosestMerc(leader)
	local weapons_sighted = false
	
	local end_this = function()
	
		if (isValid(trigger_name)) then
				
			Triggers[trigger_name].active = false
			
		end
		
		setGVAR(sector.."_checkPointer_timer_start", nil)
		setGVAR(sector.."_checkPointer_timer_set", nil)
		
	end

	local checkVisibleContact = function(index1,value1)
	
		local done = false
		
		local checkMercs = function(index2,value2)
		
			if ((canOneSeeOther(value1, value2) == true) and (healthOK(value1) == true) and (healthOK(value2) == true)) then
				local distance = service.person2person_distance(value1, value2)
				
				if (distance < check_distance) then
				
					done = true
					table.insert(visible_mercs, value2)
	
					if((weapons_check == true) and hasGun(value2,"a","primary")) then
						weapons_sighted = true
					end
				
				end
				
			end
			
		end
		
		table.foreach(CUR_MISSION.Mercs, checkMercs)
		
		if (done == true) then
		
			visible = true
			
		end
		
	end
	
	table.foreach(controllers, checkVisibleContact)
	
	if (visible == false) then 
calls.leave("checkPointer",sector)
		return 
	end

	merc = getClosestMerc(leader, visible_mercs)
	
	local timer_set = tonumber(getGVAR(sector.."_checkPointer_timer_set"))
	local timer_start = tonumber(getGVAR(sector.."_checkPointer_timer_start"))

	if (timer_set ~= 1) then
		
		local mx, my, mz, mf = getPosition(merc)
	
		addRotate(leader, mx, my, mz)
		executeOrders(leader)
		
	end

	if (timer_set ~= 1) then
	
		if ((weapons_check == true) and (weapons_sighted == true)) then
		
			if (weapons_aggressive == false) then

				if (isValid(weapons_remark)) then
				
					showComments(leader, weapons_remark, table_values.corner)
				
				end
			
			else
			
				if (isValid(combat_remark)) then
				
					showComments(leader, combat_remark, table_values.corner)
				
				end
				
				changeLocalRelations(ENEMY, team(leader))
				
				end_this()
calls.leave("checkPointer",sector)		
				return
			
			end
			
		else
		
			if (isValid(warning_remark)) then
			
				showComments(leader, warning_remark, table_values.corner)
			
			end
			
		end
			
		if (isValid(time_out) and (time_out > 0)) then
		
			setGVAR(sector.."_checkPointer_timer_start", time)
			timer_start = time
			
		else
		
			time_out = 0
			
		end
		
		setGVAR(sector.."_checkPointer_timer_set", "1")
		timer_set = 1
		
	end

	if (timer_set == 1) then
		local new_time_out = time_out
		
		if ((weapons_check == true) and (weapons_sighted == false)) then
		
			new_time_out = time_out * 1.5
		
		end
	
		if ((time - timer_start) >= new_time_out) then
			
			if (isValid(combat_remark)) then
			
				showComments(leader, combat_remark, table_values.corner)
				
			end
			
			changeLocalRelations(ENEMY, team(leader))
			
			end_this()
calls.leave("checkPointer",sector)
			return
			
		end
		
		if (weapons_check == true) then
		
			weapons_sighted = false
		
			table.foreach(controllers, checkVisibleContact)
			
			merc = getClosestMerc(leader, visible_mercs)
		
			if (weapons_sighted == true) then
calls.leave("checkPointer",sector)			
				return
		
			end
			
		end
		
	end
	
	--merc = getClosestMerc(leader, visible_mercs)
	
	if ( (service.person2person_distance(merc, leader) <= dialog_dist) and (healthOK(leader)) ) then
		
		startDlg(dialog, merc, leader)
			
		end_this()
calls.leave("checkPointer",sector)		
		return
		
	end
calls.leave("checkPointer",sector)	
end
-- 
function updateSectors(logging)
calls.enter("updateSectors")
	local log_id = C_TOOLS

	local process = function(sector, data)
		local mis_en = data.enabled
		local mis_st = NOT_STARTED
		local mis_ow = data.owner
		local mis_po = data.post
		local en = "enabled"
		local income = data.income

		enableMission(sector, mis_en)
		setMissionStatus(sector, mis_st)
		setMissionOwner(sector, mis_ow)
		setMissionPostOffice(sector, mis_po)
		setBaseIncome(sector, income)
		
		if (mis_en == false) then
			en = "disabled"
		end
		
		if (logging == true) then
			log(log_id, "UPDATE_SECTORS-> Sector:", sector, "is", mis_st, "and", en, "Owner:", mis_ow)
		end
		
	end
	
	table.foreach(Sectors, process)
calls.leave("updateSectors")
end

function initGVARS()
calls.enter("initGVARS")
	local log_id = C_TOOLS
	local vars = deepcopy(GVARS)

	local init = function(var, value)
		setGVAR(var, value)
		log(log_id, var, "=", value)
	end
	
	table.foreach(vars, init)
	
	GLOBALS_SET = true
calls.leave("initGVARS")
end

function updateGVARS(logging)
calls.enter("updateGVARS")
	local log_id = C_TOOLS
	local vars = deepcopy(GVARS)

	local update = function(index,value)
		local v = getVariable(index)
		if ((logging == true) or (tostring(value) ~= tostring(v))) then
			log(log_id, index, "is now", v)
			GVARS[index] = v
		end
	end

	table.foreach(vars, update)
	
	currentAllyTransform()
calls.leave("updateGVARS")
end

function disableAllSectors(update)
calls.enter("disableAllSectors")
	local log_id = C_TOOLS
	local s = deepcopy(Sectors)

	local process = function(sector, data)
		Sectors[sector].enabled = false
	end

	table.foreach(s, process)

	if (update == true) then
		updateSectors(false)
	end
calls.leave("disableAllSectors")
end

function enableAllSectors(update)
calls.enter("enableAllSectors")
	local log_id = C_TOOLS
	local s = deepcopy(Sectors)

	local process = function(sector, data)
		Sectors[sector].enabled = true
	end
	
	table.foreach(s, process)
	
	if (update == true) then
		updateSectors(false)
	end
calls.leave("enableAllSectors")
end

function getHiredMercs(bool)
calls.enter("getHiredMercs")
	local log_id = C_TOOLS
	local h_mercs = {}
	HIRED_MERCS = {}
	
	local process = function(merc, data)
		if ((data.hired == bool) and (data.alive == true)) then
			--log(log_id, "ADDING: "..merc.." to hired_mercs table")
			table.insert(h_mercs, merc)
			table.insert(HIRED_MERCS, merc)
		end
	end
	
	table.foreach(Mercs, process)
calls.leave("getHiredMercs")	
	return h_mercs
end

function isHired(merc)
calls.enter("isHired",merc)
	local log_id = C_TOOLS

	if ( not(isValid(merc)) ) then
		log(log_id, "   isHired         !")
calls.leave("isHired",-1)
		return -1
	end

	if (Mercs[merc] == nil) then
		log(log_id, " ", merc, "   !")
calls.leave("isHired",-1)
		return -1
	end

	if (Mercs[merc].alive == false) then
		log(log_id, " ", merc, "!")
calls.leave("isHired",0)
		return false
	end

	if (Mercs[merc].hired == true) then
calls.leave("isHired",1)
		return true
	else
calls.leave("isHired",0)
		return false
	end

end

function hasMercs()
calls.enter("hasMercs")
	local res = false
	local check = function(merc, data) 
		if ( (data.hired == true) and (data.alive == true) ) then
			res = true
			return
		end
	end
	table.foreach(Mercs, check)
calls.leave("hasMercs",res)
	return res
end

function getTableSize(t)
calls.enter("getTableSize")
	local size = 0
	local count = function(index,value)
		if ((index ~= nil) and (value ~= nil)) then
			size = size + 1
		end
	end
	table.foreach(t, count)
calls.leave("getTableSize",size)
	return size
end

function tableLog(logfile, t)
calls.enter("tableLog")
	local dump = function(index, value)
		
		if (type(value) == "table") then
			log(logfile, index)
			tableLog(logfile, value)
		else
			log(logfile, index, value)
		end
		
	end
	table.foreach(t, dump)
calls.leave("tableLog")
end

function initMercs(reinit)
calls.enter("initMercs")
	local m = deepcopy(Mercs)
	
	if (DEMO == true) then
calls.leave("initMercs")
		return
	end
	
	local run = function(merc, data)
		if(not reinit) then
			data.hired = false
		end
		if ((data.hired == false) and (data.alive == true) and (data.agency == AGENCY)) then
			if (math.random() <= MERCS_NA_PERCENT) then
				log("mercs_init", merc, "is not available")
				Mercs[merc].available = false
			else
				Mercs[merc].available = true
			end
		end
	end
	table.foreach(m, run)
calls.leave("initMercs")
end
--
function hideMercs()
calls.enter("hideMercs")
	local m = deepcopy(Mercs)
	
	local run = function(merc, data)
		Mercs[merc].available = false
	end
	
	table.foreach(m, run)
calls.leave("hideMercs")
end
--
function initSectors()
calls.enter("initSectors")
	local s = deepcopy(Sectors)
	local run = function(sector, data)
		Sectors[sector].onLoad 	= function() end
		Sectors[sector].onKill 	= function() end
		Sectors[sector].onSpawn 	= function() end
		Sectors[sector].onEnd 	= function() end
		Sectors[sector].onUpdate	= function() end
	end
	table.foreach(s, run)
calls.leave("initSectors")
end
--
function getMilitiaInfo(sector)
calls.enter("getMilitiaInfo",sector)
	local slots = {}
	local res = {}
	local total_num = 0
	for count = 1, 4, 1 do
		local mt, mc = getMilitia(sector, count)
		if (isValid(mt) and isValid(mc) and (mc ~= 0)) then
			log("auto_battle", "getMilitiaInfo", sector, count, mt, mc)
			table.insert(slots, count)
			total_num = total_num + mc
			res[count] = {}
			res[count].num = mc
			
			if (UnitsPower[mt] == nil) then
				res[count].power = 5 * mc
			else
				res[count].power = UnitsPower[mt].defense * mc
			end
			
			res[count].mtype = mt
		else
			res[count] = {}
			res[count].num = 0
			res[count].power = 0
			res[count].mtype = nil
		end
	end

	res.slots = deepcopy(slots)
	res.num = total_num
	log("auto_battle", "getMilitiaInfo: done")
calls.leave("getMilitiaInfo",res)
	return res

end
--
function initMilitia()
calls.enter("initMilitia")
	local init = function(sector, data)
		if ( (data.owner ~= CURRENT_ALLY) and (data.owner ~= PLAYER) and (data.owner ~= nil) ) then
			setMilitia(sector, 1, data.owner, 5)	
			setMilitia(sector, 2, data.owner, 5)
			setMilitia(sector, 3, data.owner, 5)
			setMilitia(sector, 4, data.owner, 5)
		else
			setMilitia2(sector, 1, "", 0)
			setMilitia2(sector, 2, "", 0)
			setMilitia2(sector, 3, "", 0)
			setMilitia2(sector, 4, "", 0)
		end
	end
	
	table.foreach(Sectors, init)
calls.leave("initMilitia")
end
--
function maximizeDefence(force)
calls.enter("maximizeDefence",force)
	local init = function(sector, data)
		if (data.owner == force) then
			setMilitia(sector, 1, data.owner, 5)	
			setMilitia(sector, 2, data.owner, 5)
			setMilitia(sector, 3, data.owner, 5)
			setMilitia(sector, 4, data.owner, 5)
		end
	end
	table.foreach(Sectors, init)
calls.leave("maximizeDefence",force)
end
--
function check_local_force(lteam)
calls.enter("check_local_force",lteam)
	local force_alive = false
	local was_dead = false
	
	local check = function(index, unit)
		if ( healthOK(unit) == true ) then
			force_alive = true
		else
			was_dead = true
		end
	end
	
	if (lteam ~= nil) then
		table.foreach(lteam, check)
	end
calls.leave("check_local_force",lteam)	
	return force_alive, was_dead
end
--
function look_for_1st_alive(lteam)
calls.enter("look_for_1st_alive",lteam)
	local alive = nil
	
	local check = function(index, unit)
		if (healthOK(unit) == true) then
			alive = unit
			return
		end
	end
	
	if (lteam ~= nil) then
		table.foreach(lteam, check)
	end
calls.leave("look_for_1st_alive",lteam)	
	return alive
end
--
function isValid(stuff)
calls.enter("isValid")
	if ( (stuff == nil) or (stuff == "") or (stuff == "_none") ) then
calls.leave("isValid")
		return false
	else
calls.leave("isValid")
		return true
	end
end
--
function resetCM()
calls.enter("resetCM")
	local log_id = C_TOOLS

	log(log_id, "Resetting CUR_MISSION table")

	CUR_MISSION = {}
	CUR_MISSION.Name = nil
	CUR_MISSION.Forces = {}
	CUR_MISSION.Units = {}
	CUR_MISSION.Mercs = {}
	CUR_MISSION.Finishing = false
	CUR_MISSION.Failed = false
	CUR_MISSION.Success = false
	CUR_MISSION.SpawnAreas = {}
	CUR_MISSION.busy_spawns = {}
	CUR_MISSION.KillTime = nil
calls.leave("resetCM")
end
--
function resetAI()
calls.enter("resetAI")
	local log_id = C_TOOLS

	log(log_id, "Resetting AI tables")

	Humans = {}
	Triggers = {}
	Players = {}
	KnownDead = {}
	VisibleEnemies = {}
	VisibleEnemies.size = 0
	WAS_TB = 0
	ENTER_COMMENT_SAID = 0
	RT_COMMENT_SAID = 0
	MILITIA_DATA = {}
calls.leave("resetAI")
end
--
function getRandomMerc()
calls.enter("getRandomMerc")
	local rnd = math.random(service.getListSize(CUR_MISSION.Mercs))
calls.leave("getRandomMerc")	
	return CUR_MISSION.Mercs[rnd]
end
--
function changeBadReputation(value)
calls.enter("changeBadReputation",value)
	if not(isValid(value)) then 
calls.leave("changeBadReputation",value)
		return 
	end
	if not(type(value) == "number") then 
calls.leave("changeBadReputation",value)
		return 
	end

	BADREPUTATION = BADREPUTATION + value
	
	if (BADREPUTATION > 100) then BADREPUTATION = 100 end
	if (BADREPUTATION < 000) then BADREPUTATION = 000 end
	
	log("bad_reputation", "was:", tostring(BADREPUTATION - value), "now:", BADREPUTATION)
calls.leave("changeBadReputation",value)	
end
--
function currentAllyTransform(new_ally_enum)
calls.enter("currentAllyTransform",new_ally_enum)
	local value = PLAYER
	local ally = new_ally_enum
	
	if ( ally == nil ) then
		ally = getGVAR("CURRENT_ALLY")
	end
	
	if ( ally == _CORP ) then
		value = CORP
	elseif ( ally == _ARMY ) then
		value = ARMY
	elseif ( ally == _BUTSI ) then
		value = BUTSI
	elseif ( ally == _MARAUDERS ) then
		value = MARAUDERS
	end
	
	CURRENT_ALLY = value
calls.leave("currentAllyTransform",new_ally_enum)
end
--
function destroyUpgrades(sector)
calls.enter("destroyUpgrades",sector)
	local u = deepcopy(Upgrades)
	
	local destroy = function(upgrade, data)
		if (data.sector == sector) then
			if (data.bought == true) then
				Upgrades[upgrade].bought = false
				--Upgrades[upgrade].onSell(sector, upgrade)
				onUpgradeDestroy(sector, upgrade)
			end
		end
	end
	
	table.foreach(u, destroy)
calls.leave("destroyUpgrades",sector)
	return
end
--
function raidSector(raider, sector)
calls.enter("raidSector",sector)
	local owner = Sectors[sector].owner
	-- some money transfers maybe
calls.leave("raidSector",sector)
	return
end
--
function deepcopy(object)
    local lookup_table = {}
    local function _copy(object)
        if type(object) ~= "table" then
            return object
        elseif lookup_table[object] then
            return lookup_table[object]
        end
        local new_table = {}
        lookup_table[object] = new_table
        for index, value in pairs(object) do
            new_table[_copy(index)] = _copy(value)
        end
        return setmetatable(new_table, getmetatable(object))
    end
    return _copy(object)
end
